Attribute VB_Name = "mdPlaneOfObject"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function PlaneOfObject(firstTopology As aTopology, workplaneName, sketchName, bNoSketch, color)

'Convenience Function to create a workplane on a planar face or in the plane of a circular or elliptical edge

'check if the selected entity belongs to a TopologyClass
If firstTopology Is Nothing Then
    MsgBox ("Enity not Selected")
Else
    Dim blnFirstTopology As Boolean
    blnFirstTopology = firstTopology.IsA("Topology")
End If

If (blnFirstTopology) Then

    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active part document
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'Get the Design
    Dim Design As aDesign
    Set Design = Part.GetDesign
    
    'Get the geometry
    Dim geom As zGeometry
    Set geom = firstTopology.GetGeometricForm
    'Get the zPlane
    Dim plane As zPlane
    Set plane = geom
        
    'Check if a workplane of the given name already exists
    Dim Found As Boolean
    Found = False

    Dim currentWorkplane As aWorkplane
    Set currentWorkplane = Part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If

    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set PlaneOfObject = Nothing
        GoTo 1000
    Else
        'Create the Plane of Object using the zPlane and workplane name
        Set PlaneOfObject = Design.CreateWorkplane(plane, workplaneName)
    End If

    'Set the Local Origin
    
    Dim identity As zMatrix
    Set identity = app.GetClass("Matrix").CreateScaleMatrix(1)
    Dim box As zBox
    Set box = plane.GetBoundingBox(identity)
    
    Dim bIsEmpty As Boolean
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        PlaneOfObject.SetLocalOrigin box.GetCenter
    End If
       
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim PlaneOfObjectSketch As aSketch
        Set PlaneOfObjectSketch = PlaneOfObject.CreateSketch(sketchName)
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        Dim colorCls As ColorClass
        Dim newColor As zColor
        Set colorCls = app.GetClass("Color")
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        PlaneOfObjectSketch.SetColor newColor
        Part.SetActiveSketch PlaneOfObjectSketch
           
    End If

Else

    MsgBox ("ImProper Selection of Entities")
    Set PlaneOfObject = Nothing

End If

1000:
End Function




